<?php
date_default_timezone_set('Asia/Jakarta');

if ($_SERVER['HTTP_HOST'] === 'localhost') {
    define('BASE_URL', 'http://localhost/app-fp');
} else {
    define('BASE_URL', 'https://financialcare.my.id');
}

function loadEnv($path = __DIR__ . "/.env") {
    if (!file_exists($path)) return;

    $lines = file($path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

    foreach ($lines as $line) {
        if (strpos(trim($line), '#') === 0) continue;

        if (strpos($line, '=') !== false) {
            list($key, $value) = explode("=", $line, 2);
            $key = trim($key);
            $value = trim($value);

            $_ENV[$key] = $value;
            putenv("$key=$value"); 
        }
    }
}

loadEnv();
?>